# QR-Code Generator

Ein selbst gehosteter QR-Code-Generator, der QR-Codes lokal als PNG oder SVG erzeugt. Keine externen Dienste, keine Abhängigkeiten, kein Composer nötig.

## URL-Parameter

Der Generator akzeptiert folgende GET-Parameter:

### `data` (erforderlich)
Die Daten, die im QR-Code kodiert werden sollen.

**Beispiele:**
- `data=https://example.com` - URL
- `data=Hello World` - Text
- `data=+491234567890` - Telefonnummer
- `data=MATMSG:TO:test@example.com;SUB:Betreff;BODY:Nachricht;;` - E-Mail

**Standardwert:** `https://b-prisma.de`

### `format` (optional)
Das Ausgabeformat des QR-Codes.

**Mögliche Werte:**
- `png` - PNG-Bild (Standard)
- `svg` - SVG-Vektorgrafik

**Beispiel:**
```
?format=svg
```

**Standardwert:** `png`

### `filename` (optional)
Der Dateiname für den Download.

**Beispiel:**
```
?filename=mein-qrcode.png
```

**Standardwert:** `qrcode.{format}` (z.B. `qrcode.png`)

### `size` (optional)
Die gewünschte Bildgröße in Pixeln. Die tatsächliche Größe kann leicht abweichen, da sie auf die Anzahl der QR-Code-Module basiert.

**Beispiel:**
```
?size=1200
```

**Standardwert:** `300`

**Hinweis:** Die finale Bildgröße wird automatisch basierend auf der Modulanzahl berechnet. Bei sehr kurzen Daten (wenige Module) kann die tatsächliche Größe etwas größer sein als angegeben.

### `bg` (optional)
Die Hintergrundfarbe des QR-Codes.

**Mögliche Werte:**
- `transparent` - Transparenter Hintergrund
- Hex-Farbe ohne `#` - z.B. `ffffff` für weiß, `000000` für schwarz

**Beispiele:**
```
?bg=transparent
?bg=ffffff
?bg=ff0000
```

**Standardwert:** `transparent`

### `fg` (optional)
Die Vordergrundfarbe (die QR-Code-Module).

**Format:** Hex-Farbe ohne `#`

**Beispiele:**
```
?fg=000000  (schwarz)
?fg=ff0000  (rot)
?fg=0000ff  (blau)
```

**Standardwert:** `000000` (schwarz)

## Beispiele

### Einfacher QR-Code
```
generator.php?data=https://example.com
```

### Großer QR-Code mit benutzerdefinierten Farben
```
generator.php?data=https://example.com&size=1200&fg=ff0000&bg=ffffff
```

### SVG-Format mit transparentem Hintergrund
```
generator.php?data=Hello World&format=svg&bg=transparent
```

### QR-Code mit benutzerdefiniertem Dateinamen
```
generator.php?data=https://graphisoft.de&filename=Wasserfall9671.png&size=1200
```

### Vollständiges Beispiel
```
generator.php?data=https://graphisoft.de/&filename=Wasserfall9671.png&size=1200&bg=transparent&fg=000000&format=png
```

## Technische Details

- **Bibliothek:** chillerlan/php-qrcode
- **Fehlerkorrektur-Level:** L (7%)
- **Skalierung:** Automatisch basierend auf gewünschter Größe und Modulanzahl
- **Farbformat:** RGB-Arrays für PNG, Hex-Strings für SVG

## Hinweise

- Die Bildgröße wird automatisch berechnet: `scale = size / moduleCount`
- Bei sehr kurzen Daten kann die tatsächliche Größe etwas größer sein als angegeben
- Transparente Hintergründe funktionieren nur bei PNG-Format
- SVG-Format ist vektorbasiert und skaliert ohne Qualitätsverlust


