<?php
namespace chillerlan\Settings;

use InvalidArgumentException;
use ReflectionClass;
use ReflectionException;
use ReflectionProperty;

#[\AllowDynamicProperties]
abstract class SettingsContainerAbstract{

    public function __construct(array $properties = null){
        if($properties !== null){
            foreach($properties as $key => $value){
                $this->setProperty($key, $value);
            }
        }

        $this->lock();
    }

    protected function setProperty(string $key, $value): void{
        $r = new ReflectionClass($this);
        
        // Prüfe, ob die Property existiert (auch protected)
        if($r->hasProperty($key)){
            $prop = $r->getProperty($key);
            $prop->setAccessible(true);
            
            // Prüfe, ob es einen Setter gibt
            $setter = 'set_' . $key;
            if($r->hasMethod($setter)){
                $method = $r->getMethod($setter);
                $method->setAccessible(true);
                $method->invoke($this, $value);
            } else {
                $prop->setValue($this, $value);
            }
        } else {
            // Fallback für dynamische Properties
            $this->{$key} = $value;
        }
    }

    public function __get(string $name){
        $r = new ReflectionClass($this);
        
        if($r->hasProperty($name)){
            $prop = $r->getProperty($name);
            $prop->setAccessible(true);
            return $prop->getValue($this);
        }
        
        return null;
    }

    public function __set(string $name, $value): void{
        $this->setProperty($name, $value);
    }

    protected function lock(): void{
        $r = new ReflectionClass($this);

        foreach($r->getProperties(ReflectionProperty::IS_PUBLIC) as $prop){
            $prop->setAccessible(true);
            $prop->setValue($this, $this->castValue($prop->getValue(), $prop));
        }
    }

    protected function castValue($value, ReflectionProperty $property){
        return $value;
    }
}
